/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.surface.rules;

import com.mojang.serialization.Codec;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.interfaces.NumericProvider;
import org.betterx.bclib.mixin.common.SurfaceRulesContextAccessor;
import org.betterx.bclib.util.MHelper;

public class NetherNoiseCondition
implements NumericProvider {
    public static final Codec<NetherNoiseCondition> CODEC = Codec.BYTE.fieldOf("nether_noise").xmap(obj -> (NetherNoiseCondition)Conditions.NETHER_NOISE, obj -> (byte)0).codec();

    NetherNoiseCondition() {
    }

    @Override
    public Codec<? extends NumericProvider> pcodec() {
        return CODEC;
    }

    @Override
    public int getNumber(SurfaceRulesContextAccessor context) {
        int x = context.getBlockX();
        int y = context.getBlockY();
        int z = context.getBlockZ();
        double value = Conditions.NETHER_VOLUME_NOISE.noiseContext.noise.eval((double)x * Conditions.NETHER_VOLUME_NOISE.scaleX, (double)y * Conditions.NETHER_VOLUME_NOISE.scaleY, (double)z * Conditions.NETHER_VOLUME_NOISE.scaleZ);
        int offset = Conditions.NETHER_VOLUME_NOISE.noiseContext.random.m_188503_(20) == 0 ? 3 : 0;
        float cmp = MHelper.randRange(0.4f, 0.5f, Conditions.NETHER_VOLUME_NOISE.noiseContext.random);
        if (value > (double)cmp || value < (double)(-cmp)) {
            return 2 + offset;
        }
        if (value > (double)Conditions.NETHER_VOLUME_NOISE.range.m_214084_(Conditions.NETHER_VOLUME_NOISE.noiseContext.random)) {
            return 0 + offset;
        }
        return 1 + offset;
    }
}

